# 演示包的使用方法

print("=== 包的导入和使用演示 ===")

# 方法1: 导入整个包
import mypackage
print(f"\n包版本: {mypackage.__version__}")
print(f"包作者: {mypackage.__author__}")

# 使用包中的函数
print(f"\n使用包中的函数:")
print(f"5 + 3 = {mypackage.add(5, 3)}")
print(f"4 * 6 = {mypackage.multiply(4, 6)}")
print(f"大写单词: {mypackage.capitalize_words('hello world python')}")
print(f"反转字符串: {mypackage.reverse_string('Python')}")

# 使用包中的类
print(f"\n使用包中的类:")
processor = mypackage.DataProcessor()
processor.add_data(10)
processor.add_data(20)
processor.add_data(30)
print(f"数据平均值: {processor.get_average()}")
print(f"数据最大值: {processor.get_max()}")

# 方法2: 从包导入特定模块
print(f"\n=== 导入特定模块 ===")
from mypackage import math_utils, string_utils

print(f"10 / 2 = {math_utils.divide(10, 2)}")
print(f"2^3 = {math_utils.power(2, 3)}")
print(f"单词数量: {string_utils.count_words('Python is awesome')}")

# 方法3: 导入子包
print(f"\n=== 导入子包 ===")
from mypackage.subpackage import factorial, fibonacci

print(f"5的阶乘: {factorial(5)}")
print(f"斐波那契数列第10项: {fibonacci(10)}")

# 方法4: 使用相对导入（在包内部）
print(f"\n=== 直接导入子包模块 ===")
from mypackage.subpackage.advanced_math import is_prime

print(f"17是质数吗? {is_prime(17)}")
print(f"18是质数吗? {is_prime(18)}")