#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
UDP服务器示例
"""

import socket
import time

def start_udp_server():
    """启动UDP服务器"""
    # 创建UDP socket对象
    server_socket = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    
    # 绑定地址和端口
    host = 'localhost'
    port = 9999
    server_socket.bind((host, port))
    
    print(f"[{time.strftime('%Y-%m-%d %H:%M:%S')}] UDP服务器启动，监听 {host}:{port}")
    
    try:
        while True:
            # 接收数据和客户端地址
            data, client_address = server_socket.recvfrom(1024)
            message = data.decode('utf-8')
            
            print(f"[{time.strftime('%Y-%m-%d %H:%M:%S')}] 收到来自 {client_address} 的消息: {message}")
            
            # 回复客户端
            response = f"UDP服务器收到: {message}"
            server_socket.sendto(response.encode('utf-8'), client_address)
            print(f"[{time.strftime('%Y-%m-%d %H:%M:%S')}] 已回复客户端 {client_address}")
            
    except KeyboardInterrupt:
        print(f"\n[{time.strftime('%Y-%m-%d %H:%M:%S')}] UDP服务器正在关闭...")
    finally:
        server_socket.close()
        print(f"[{time.strftime('%Y-%m-%d %H:%M:%S')}] UDP服务器已关闭")

if __name__ == '__main__':
    start_udp_server()