# -*- coding: utf-8 -*-
"""继承与多态示例"""

print("=== 测试1: 基本继承 ===")
class Animal:
    """动物基类"""
    def __init__(self, name, age):
        self.name = name
        self.age = age
        print(f"创建了一个动物: {self.name}")
    
    def speak(self):
        """发出声音"""
        return "动物发出声音"
    
    def info(self):
        """显示信息"""
        return f"动物名称: {self.name}, 年龄: {self.age}"

class Dog(Animal):
    """狗类 - 继承自动物类"""
    def __init__(self, name, age, breed):
        # 调用父类的构造方法
        super().__init__(name, age)
        self.breed = breed
        print(f"这是一只{self.breed}狗")
    
    def speak(self):
        """重写父类的方法"""
        return "汪汪!"
    
    def info(self):
        """重写并扩展父类的方法"""
        base_info = super().info()
        return f"{base_info}, 品种: {self.breed}"
    
    def fetch(self):
        """狗特有的方法"""
        return f"{self.name}在捡球"

class Cat(Animal):
    """猫类 - 继承自动物类"""
    def __init__(self, name, age, color):
        super().__init__(name, age)
        self.color = color
        print(f"这是一只{self.color}猫")
    
    def speak(self):
        """重写父类的方法"""
        return "喵喵!"
    
    def info(self):
        base_info = super().info()
        return f"{base_info}, 颜色: {self.color}"
    
    def climb(self):
        """猫特有的方法"""
        return f"{self.name}在爬树"

# 创建实例
animal = Animal("未知动物", 1)
dog = Dog("旺财", 3, "金毛")
cat = Cat("咪咪", 2, "橘色")

print("\n基本信息:")
print(animal.info())
print(dog.info())
print(cat.info())

print("\n发出声音:")
print(f"{animal.name}: {animal.speak()}")
print(f"{dog.name}: {dog.speak()}")
print(f"{cat.name}: {cat.speak()}")

print("\n特有方法:")
print(dog.fetch())
print(cat.climb())

print("\n类型检查:")
print(f"dog是Animal的实例: {isinstance(dog, Animal)}")
print(f"dog是Dog的实例: {isinstance(dog, Dog)}")
print(f"dog是Cat的实例: {isinstance(dog, Cat)}")
print(f"Dog是Animal的子类: {issubclass(Dog, Animal)}")

print("\n=== 测试2: 多态性 ===")
def make_speak(animal):
    """多态函数 - 接受任何实现了speak方法的对象"""
    return animal.speak()

print(f"动物说: {make_speak(animal)}")
print(f"狗说: {make_speak(dog)}")
print(f"猫说: {make_speak(cat)}")

print("\n=== 测试3: 多重继承 ===")
class Flyable:
    """可飞行的能力"""
    def __init__(self, max_height):
        self.max_height = max_height
        print(f"可以飞行，最大高度: {self.max_height}米")
    
    def fly(self):
        return f"飞行中，当前高度: {self.max_height/2}米"

class Swimmable:
    """可游泳的能力"""
    def __init__(self, max_depth):
        self.max_depth = max_depth
        print(f"可以游泳，最大深度: {self.max_depth}米")
    
    def swim(self):
        return f"游泳中，当前深度: {self.max_depth/2}米"

class Duck(Animal, Flyable, Swimmable):
    """鸭子类 - 多重继承"""
    def __init__(self, name, age, species):
        Animal.__init__(self, name, age)
        Flyable.__init__(self, 10)  # 最大飞行高度10米
        Swimmable.__init__(self, 5)  # 最大游泳深度5米
        self.species = species
        print(f"这是一只{self.species}鸭子")
    
    def speak(self):
        return "嘎嘎!"

# 创建鸭子实例
duck = Duck("唐老鸭", 2, "绿头")

print("\n鸭子的能力:")
print(duck.info())
print(f"{duck.name}说: {duck.speak()}")
print(duck.fly())
print(duck.swim())

print("\n类型检查:")
print(f"duck是Animal的实例: {isinstance(duck, Animal)}")
print(f"duck是Flyable的实例: {isinstance(duck, Flyable)}")
print(f"duck是Swimmable的实例: {isinstance(duck, Swimmable)}")

print("\n=== 测试4: 方法解析顺序(MRO) ===")
print(f"Duck的MRO: {[cls.__name__ for cls in Duck.__mro__]}")

print("\n程序结束")