# -*- coding: utf-8 -*-
"""文件操作测试脚本"""

# 测试1: 基本文件读取
print("=== 测试1: 基本文件读取 ===")
with open('sample.txt', 'r', encoding='utf-8') as f:
    content = f.read()
    print(f"文件内容: {repr(content)}")

print("\n=== 测试2: 逐行读取 ===")
with open('sample.txt', 'r', encoding='utf-8') as f:
    for i, line in enumerate(f, 1):
        print(f"第{i}行: {repr(line)}")

print("\n=== 测试3: readline()方法 ===")
with open('sample.txt', 'r', encoding='utf-8') as f:
    line1 = f.readline()
    line2 = f.readline()
    print(f"第一行: {repr(line1)}")
    print(f"第二行: {repr(line2)}")

print("\n=== 测试4: readlines()方法 ===")
with open('sample.txt', 'r', encoding='utf-8') as f:
    lines = f.readlines()
    print(f"所有行: {lines}")

print("\n=== 测试5: 文件指针操作 ===")
with open('numbers.txt', 'r') as f:
    print(f"初始位置: {f.tell()}")
    data = f.read(5)
    print(f"读取5个字符: {repr(data)}")
    print(f"当前位置: {f.tell()}")
    f.seek(0)
    print(f"重置后位置: {f.tell()}")
    print(f"重新读取: {repr(f.read(10))}")

print("\n=== 测试6: 文件写入 ===")
with open('output.txt', 'w', encoding='utf-8') as f:
    f.write("Hello, Python!\n")
    f.write("文件写入测试\n")
    print("文件写入完成")

# 验证写入结果
with open('output.txt', 'r', encoding='utf-8') as f:
    print(f"写入的内容: {repr(f.read())}")

print("\n=== 测试7: 二进制文件读取 ===")
with open('binary_sample.bin', 'rb') as f:
    data = f.read(10)
    print(f"前10个字节: {data}")
    print(f"十六进制表示: {data.hex()}")