# 异常处理性能测试

import time

def test_exception_performance():
    print("异常处理性能测试")
    
    # 测试LBYL方式的性能
    def lbyl_approach(data, keys):
        result = 0
        start_time = time.time()
        for key in keys:
            if key in data:  # 先检查
                result += data[key]
        return time.time() - start_time
    
    # 测试EAFP方式的性能
    def eafp_approach(data, keys):
        result = 0
        start_time = time.time()
        for key in keys:
            try:
                result += data[key]  # 直接尝试
            except KeyError:
                pass
        return time.time() - start_time
    
    # 准备测试数据
    data = {str(i): i for i in range(1000)}  # 字典包含1000个键
    
    # 测试场景1：所有键都存在（最佳情况）
    existing_keys = [str(i) for i in range(500)]  # 使用存在的键
    
    # 测试场景2：所有键都不存在（最坏情况）
    missing_keys = [str(i+1000) for i in range(500)]  # 使用不存在的键
    
    # 测试场景3：混合情况
    mixed_keys = [str(i) if i % 2 == 0 else str(i+1000) for i in range(500)]
    
    # 执行测试
    iterations = 1000  # 增加迭代次数以获得更准确的结果
    
    print("\n场景1: 所有键都存在")
    lbyl_time = 0
    eafp_time = 0
    for _ in range(iterations):
        lbyl_time += lbyl_approach(data, existing_keys)
        eafp_time += eafp_approach(data, existing_keys)
    print(f"LBYL方式耗时: {lbyl_time:.6f}秒")
    print(f"EAFP方式耗时: {eafp_time:.6f}秒")
    print(f"LBYL/EAFP比率: {lbyl_time/eafp_time:.2f}")
    
    print("\n场景2: 所有键都不存在")
    lbyl_time = 0
    eafp_time = 0
    for _ in range(iterations):
        lbyl_time += lbyl_approach(data, missing_keys)
        eafp_time += eafp_approach(data, missing_keys)
    print(f"LBYL方式耗时: {lbyl_time:.6f}秒")
    print(f"EAFP方式耗时: {eafp_time:.6f}秒")
    print(f"LBYL/EAFP比率: {lbyl_time/eafp_time:.2f}")
    
    print("\n场景3: 混合情况(一半键存在，一半不存在)")
    lbyl_time = 0
    eafp_time = 0
    for _ in range(iterations):
        lbyl_time += lbyl_approach(data, mixed_keys)
        eafp_time += eafp_approach(data, mixed_keys)
    print(f"LBYL方式耗时: {lbyl_time:.6f}秒")
    print(f"EAFP方式耗时: {eafp_time:.6f}秒")
    print(f"LBYL/EAFP比率: {lbyl_time/eafp_time:.2f}")

if __name__ == "__main__":
    test_exception_performance()