# -*- coding: utf-8 -*-
"""基本类定义和使用示例"""

print("=== 测试1: 基本类定义 ===")
class Person:
    """人员类 - 演示基本类定义"""
    # 类属性
    species = "智人"
    count = 0
    
    def __init__(self, name, age):
        """构造方法 - 初始化对象"""
        self.name = name  # 实例属性
        self.age = age    # 实例属性
        Person.count += 1
        print(f"创建了一个人员对象: {self.name}")
    
    def introduce(self):
        """实例方法 - 自我介绍"""
        return f"我是{self.name}，今年{self.age}岁"
    
    def have_birthday(self):
        """实例方法 - 过生日"""
        self.age += 1
        print(f"{self.name}过生日了，现在{self.age}岁")
    
    @classmethod
    def get_count(cls):
        """类方法 - 获取人员总数"""
        return f"目前共有{cls.count}个人员对象"
    
    @staticmethod
    def is_adult(age):
        """静态方法 - 判断是否成年"""
        return age >= 18

# 创建对象实例
person1 = Person("张三", 25)
person2 = Person("李四", 17)

print(f"\n类属性 species: {Person.species}")
print(f"通过实例访问类属性: {person1.species}")

print(f"\n实例方法调用:")
print(person1.introduce())
print(person2.introduce())

print(f"\n类方法调用:")
print(Person.get_count())
print(person1.get_count())  # 也可以通过实例调用

print(f"\n静态方法调用:")
print(f"张三是否成年: {Person.is_adult(person1.age)}")
print(f"李四是否成年: {Person.is_adult(person2.age)}")

print(f"\n修改实例属性:")
person1.have_birthday()
print(person1.introduce())

print(f"\n动态添加属性:")
person1.city = "北京"
print(f"张三的城市: {person1.city}")
# print(f"李四的城市: {person2.city}")  # 这会报错，因为李四没有city属性

print(f"\n对象的唯一性:")
print(f"person1的id: {id(person1)}")
print(f"person2的id: {id(person2)}")
print(f"person1 == person2: {person1 == person2}")
print(f"person1 is person2: {person1 is person2}")

print("\n=== 测试2: 私有属性演示 ===")
class BankAccount:
    """银行账户类 - 演示私有属性"""
    def __init__(self, account_number, initial_balance=0):
        self.account_number = account_number  # 公有属性
        self._balance = initial_balance       # 受保护属性（约定）
        self.__pin = "1234"                  # 私有属性
    
    def deposit(self, amount):
        """存款"""
        if amount > 0:
            self._balance += amount
            print(f"存款{amount}元，余额: {self._balance}元")
        else:
            print("存款金额必须大于0")
    
    def withdraw(self, amount, pin):
        """取款"""
        if pin != self.__pin:
            print("密码错误")
            return False
        if amount > self._balance:
            print("余额不足")
            return False
        self._balance -= amount
        print(f"取款{amount}元，余额: {self._balance}元")
        return True
    
    def get_balance(self):
        """获取余额"""
        return self._balance

account = BankAccount("123456789", 1000)
print(f"账户号码: {account.account_number}")
print(f"初始余额: {account.get_balance()}元")

account.deposit(500)
account.withdraw(200, "1234")
account.withdraw(200, "0000")  # 密码错误

print(f"\n访问受保护属性（不推荐）: {account._balance}")
print(f"尝试访问私有属性:")
try:
    print(account.__pin)
except AttributeError as e:
    print(f"错误: {e}")

print(f"通过名称改写访问私有属性: {account._BankAccount__pin}")

print("\n=== 测试3: 特殊方法演示 ===")
class Point:
    """点类 - 演示特殊方法"""
    def __init__(self, x, y):
        self.x = x
        self.y = y
    
    def __str__(self):
        """字符串表示 - 用户友好"""
        return f"点({self.x}, {self.y})"
    
    def __repr__(self):
        """字符串表示 - 开发者友好"""
        return f"Point({self.x}, {self.y})"
    
    def __add__(self, other):
        """加法运算符重载"""
        return Point(self.x + other.x, self.y + other.y)
    
    def __eq__(self, other):
        """相等比较"""
        return self.x == other.x and self.y == other.y
    
    def __len__(self):
        """支持len()函数"""
        return int((self.x**2 + self.y**2)**0.5)

p1 = Point(3, 4)
p2 = Point(1, 2)

print(f"p1: {p1}")  # 调用__str__
print(f"p2: {repr(p2)}")  # 调用__repr__
print(f"p1 + p2: {p1 + p2}")  # 调用__add__
print(f"p1 == p2: {p1 == p2}")  # 调用__eq__
print(f"len(p1): {len(p1)}")  # 调用__len__

print("\n程序结束")