#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
TCP服务器示例
"""

import socket
import threading
import time

def handle_client(client_socket, client_address):
    """处理客户端连接"""
    print(f"[{time.strftime('%Y-%m-%d %H:%M:%S')}] 客户端 {client_address} 已连接")
    
    try:
        while True:
            # 接收客户端数据
            data = client_socket.recv(1024)
            if not data:
                break
            
            message = data.decode('utf-8')
            print(f"[{time.strftime('%Y-%m-%d %H:%M:%S')}] 收到来自 {client_address} 的消息: {message}")
            
            # 回复客户端
            response = f"服务器收到: {message}"
            client_socket.send(response.encode('utf-8'))
            
    except Exception as e:
        print(f"[{time.strftime('%Y-%m-%d %H:%M:%S')}] 处理客户端 {client_address} 时发生错误: {e}")
    finally:
        client_socket.close()
        print(f"[{time.strftime('%Y-%m-%d %H:%M:%S')}] 客户端 {client_address} 已断开连接")

def start_server():
    """启动TCP服务器"""
    # 创建socket对象
    server_socket = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    
    # 设置socket选项，允许地址重用
    server_socket.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
    
    # 绑定地址和端口
    host = 'localhost'
    port = 8888
    server_socket.bind((host, port))
    
    # 开始监听
    server_socket.listen(5)
    print(f"[{time.strftime('%Y-%m-%d %H:%M:%S')}] TCP服务器启动，监听 {host}:{port}")
    
    try:
        while True:
            # 接受客户端连接
            client_socket, client_address = server_socket.accept()
            
            # 为每个客户端创建新线程
            client_thread = threading.Thread(
                target=handle_client,
                args=(client_socket, client_address)
            )
            client_thread.daemon = True
            client_thread.start()
            
    except KeyboardInterrupt:
        print(f"\n[{time.strftime('%Y-%m-%d %H:%M:%S')}] 服务器正在关闭...")
    finally:
        server_socket.close()
        print(f"[{time.strftime('%Y-%m-%d %H:%M:%S')}] 服务器已关闭")

if __name__ == '__main__':
    start_server()