# 演示sys.path和模块搜索机制

import sys
import os

print("=== Python模块搜索路径演示 ===")
print("\n当前sys.path内容:")
for i, path in enumerate(sys.path):
    print(f"{i+1}. {path}")

print(f"\n当前工作目录: {os.getcwd()}")
print(f"脚本所在目录: {os.path.dirname(os.path.abspath(__file__))}")

# 演示动态添加搜索路径
print("\n=== 动态修改搜索路径 ===")
new_path = r"C:\temp\my_modules"
print(f"添加新路径: {new_path}")
sys.path.append(new_path)
print(f"当前sys.path长度: {len(sys.path)}")
print(f"最后一个路径: {sys.path[-1]}")

# 演示sys.modules缓存
print("\n=== 模块缓存演示 ===")
print(f"已加载的模块数量: {len(sys.modules)}")
print("\n部分已加载的模块:")
module_names = list(sys.modules.keys())[:10]
for name in module_names:
    print(f"  - {name}")

# 检查特定模块是否已加载
if 'my_module' in sys.modules:
    print("\nmy_module已在缓存中")
else:
    print("\nmy_module未在缓存中")

# 导入模块后再次检查
import my_module
if 'my_module' in sys.modules:
    print("导入后，my_module已在缓存中")
    print(f"模块对象: {sys.modules['my_module']}")
    print(f"模块文件路径: {sys.modules['my_module'].__file__}")