# 演示模块的重新加载

import importlib
import my_module

print("=== 模块重新加载演示 ===")

# 第一次导入模块
print("\n第一次导入my_module:")
print(f"模块版本: {my_module.MODULE_VERSION}")
print(my_module.greet("World"))

# 修改模块中的变量
print("\n修改模块中的变量:")
my_module.MODULE_VERSION = "2.0.0"
print(f"修改后的模块版本: {my_module.MODULE_VERSION}")

# 再次导入模块（不会重新加载）
print("\n再次导入模块（不会重新加载）:")
import my_module
print(f"再次导入后的模块版本: {my_module.MODULE_VERSION}")

# 使用importlib.reload()重新加载模块
print("\n使用importlib.reload()重新加载模块:")
my_module = importlib.reload(my_module)
print(f"重新加载后的模块版本: {my_module.MODULE_VERSION}")

# 注意：重新加载会执行模块级代码，但不会重置模块内的变量
print("\n注意：重新加载不会重置已修改的变量，除非模块中有明确的赋值")