#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
字典推导式和集合推导式演示代码
"""

# 字典推导式基本用法
print("=== 字典推导式基本用法 ===")
numbers = [1, 2, 3, 4, 5]
square_dict = {x: x**2 for x in numbers}
print(f"数字及其平方的字典: {square_dict}")

# 字典推导式条件过滤
print("\n=== 字典推导式条件过滤 ===")
even_square_dict = {x: x**2 for x in numbers if x % 2 == 0}
print(f"偶数及其平方的字典: {even_square_dict}")

# 字符串处理字典推导式
print("\n=== 字符串处理字典推导式 ===")
words = ['apple', 'banana', 'cherry', 'date']
word_length_dict = {word: len(word) for word in words}
print(f"单词长度字典: {word_length_dict}")

# 字典键值互换
print("\n=== 字典键值互换 ===")
original_dict = {'a': 1, 'b': 2, 'c': 3}
reversed_dict = {v: k for k, v in original_dict.items()}
print(f"原始字典: {original_dict}")
print(f"键值互换后: {reversed_dict}")

# 集合推导式基本用法
print("\n=== 集合推导式基本用法 ===")
numbers_with_duplicates = [1, 2, 2, 3, 3, 4, 5, 5]
unique_squares = {x**2 for x in numbers_with_duplicates}
print(f"包含重复元素的列表: {numbers_with_duplicates}")
print(f"去重后的平方集合: {unique_squares}")

# 集合推导式条件过滤
print("\n=== 集合推导式条件过滤 ===")
text = "Hello World Python Programming"
vowels = {char.lower() for char in text if char.lower() in 'aeiou'}
print(f"文本: {text}")
print(f"元音字母集合: {vowels}")

# 集合运算
print("\n=== 集合运算 ===")
set1 = {x for x in range(1, 6)}
set2 = {x for x in range(3, 8)}
print(f"集合1: {set1}")
print(f"集合2: {set2}")
print(f"交集: {set1 & set2}")
print(f"并集: {set1 | set2}")
print(f"差集: {set1 - set2}")

# 嵌套推导式
print("\n=== 嵌套推导式 ===")
students = ['Alice', 'Bob', 'Charlie']
subjects = ['Math', 'Science', 'English']
# 创建学生-科目组合字典
student_subjects = {student: [f"{student}_{subject}" for subject in subjects] for student in students}
print(f"学生科目组合: {student_subjects}")